#!/usr/bin/env python
import pickle
from ar_sim.common.fractal_fits import load_D_values, fit_fractal_curve

def main():
    n, D, _ = load_D_values("data/D_values.csv")
    popt, _ = fit_fractal_curve(n, D)
    with open("data/fractal_fit.pkl", "wb") as f:
        pickle.dump(popt, f)
    print("Saved fractal_fit.pkl")

if __name__ == "__main__":
    main()
